/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerAbstractCrop;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HarvestHandlerCropLike
extends HarvestHandlerAbstractCrop {
    private final IntegerProperty ageProperty;
    private final int minAge;
    private final int maxAge;
    private final Predicate<ItemStack> isSeed;

    public HarvestHandlerCropLike(Predicate<BlockState> blockChecker, IntegerProperty ageProperty, Predicate<ItemStack> isSeed) {
        super(blockChecker);
        this.ageProperty = ageProperty;
        this.isSeed = isSeed;
        this.minAge = ageProperty.m_6908_().stream().mapToInt(Integer::intValue).min().orElse(0);
        this.maxAge = ageProperty.m_6908_().stream().mapToInt(Integer::intValue).max().orElse(7);
    }

    @Override
    protected boolean isSeed(Level world, BlockPos pos, BlockState state, ItemStack stack) {
        return this.isSeed.test(stack);
    }

    @Override
    protected boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.ageProperty) == this.maxAge;
    }

    @Override
    protected BlockState withMinAge(BlockState state) {
        return (BlockState)state.m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(this.minAge));
    }
}

